package com.agilex.healthcare.veteranappointment.utils;

import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import gov.va.vamf.security.v1.VamfUser;
import com.google.common.base.Preconditions;

public class VamfUserTransformer {

    private static final String DOB_FORMAT = "yyyy-MM-dd";

    private VamfUserTransformer() {
        // private to stop instatiation
    }

    /**
     * Converts a given {@link VamfUser} to a commons {@link Patient} that can be used to store in a databse.
     * @param vamfUser The  VamfUser to create the Patient from. Must not be null.
     * @return A Patient object that corresponds to the given vamfUser. Never null.
     */
    public static Patient getPatient(final VamfUser vamfUser) {
        Preconditions.checkNotNull(vamfUser, "The vamfUser cannot be null");

        final Patient returnPatient = new Patient();
        final VamfUser.Patient vamfPatient = vamfUser.getPatient();

        returnPatient.setPatientIdentifier(new PatientIdentifier("EDIPI", vamfPatient.getEdipid()));
        returnPatient.setDisplayName(vamfPatient.getLastName() + ", " + vamfPatient.getFirstName());
        returnPatient.setFirstName(vamfPatient.getFirstName());
        returnPatient.setLastName(vamfPatient.getLastName());
        returnPatient.setMiddleName(vamfPatient.getMiddleName());
        returnPatient.setMiddleInitial(vamfPatient.getMiddleInitial());
        returnPatient.setSsn(vamfPatient.getSsn());
        returnPatient.setGender(vamfPatient.getGender());
        returnPatient.setWardLocation(vamfPatient.getWardLocation());
        returnPatient.setRoombed(vamfPatient.getRoombed());
        returnPatient.setAge(vamfPatient.getAge());
        returnPatient.setDateOfBirth(new DOBDate(DOB_FORMAT, vamfPatient.getDateOfBirth()));

        return returnPatient;
    }

}